PXRMVPOV ; SLC/PKR - Code to handle VPOV ;10/21/2005
 ;;2.0;CLINICAL REMINDERS;**4**;Feb 04, 2005;Build 21
 ;
 ;====================================================
FPDAT(DFN,TAXARR,NGET,SDIR,BDT,EDT,FLIST) ;Find data for a patient.
 N DAS,DATE,DS,EDTT,ICDP,IND,NFOUND,NODE,NNODE,TE,TLIST,TS
 N TDATE,TIND
 I $G(^PXRMINDX(9000010.07,"DATE BUILT"))="" D  Q
 . D NOINDEX^PXRMERRH("TX",TAXARR("IEN"),9000010.07)
 I '$D(^PXRMINDX(9000010.07,"PPI",DFN)) Q
 S NNODE=+$P($G(TAXARR("PDS",9000010.07,80)),U,2)
 I NNODE=0 Q
 S EDTT=$S(EDT[".":EDT+.0000001,1:EDT+.240001)
 S DS=$S(SDIR=+1:BDT-.000001,1:EDTT)
 S TS=$O(TAXARR(80,""))-1
 S TE=$O(TAXARR(80,""),-1)
 S NFOUND=0
 F IND=1:1:NNODE D
 . S NODE=TAXARR("PDS",9000010.07,80,IND)
 . S ICDP=TS
 . F  S ICDP=$O(^PXRMINDX(9000010.07,"PPI",DFN,NODE,ICDP)) Q:(ICDP>TE)!(ICDP="")  D
 .. I '$D(TAXARR(80,ICDP)) Q
 .. S DATE=DS
 .. F  S DATE=+$O(^PXRMINDX(9000010.07,"PPI",DFN,NODE,ICDP,DATE),SDIR) Q:$S(DATE=0:1,DATE<BDT:1,DATE>EDTT:1,1:0)  D
 ... S DAS=$O(^PXRMINDX(9000010.07,"PPI",DFN,NODE,ICDP,DATE,""))
 ... S NFOUND=NFOUND+1
 ... S TLIST(DATE,NFOUND)=DAS_U_ICDP_U_NODE
 ... I NFOUND>NGET D
 .... S TDATE=$O(TLIST(""),-SDIR),TIND=$O(TLIST(TDATE,""))
 .... K TLIST(TDATE,TIND)
 ;Return up to NGET of the most recent entries.
 S NFOUND=0
 S DATE=""
 F  S DATE=$O(TLIST(DATE),SDIR) Q:(DATE="")!(NFOUND=NGET)  D
 . S IND=0
 . F  S IND=$O(TLIST(DATE,IND)) Q:(IND="")!(NFOUND=NGET)  D
 .. S NFOUND=NFOUND+1
 .. S FLIST(DATE,NFOUND,9000010.07)=TLIST(DATE,IND)
 Q
 ;
 ;====================================================
GETDATA(DAS,FIEVT) ;Return data for a specified V POV entry.
 ;DBIA #4250
 D VPOV^PXPXRM(DAS,.FIEVT)
 Q
 ;
 ;====================================================
GPLIST(TAXARR,NOCC,BDT,EDT,PLIST) ;Build patient list for V POV entries.
 N DAS,DATE,DFN,DS,ICDP,IND,NFOUND,NODE,NNODE,TEMP,TLIST
 I $G(^PXRMINDX(9000010.07,"DATE BUILT"))="" D  Q
 . D NOINDEX^PXRMERRH("TX",TAXARR("IEN"),9000010.07)
 S TLIST="GPLIST_PXRMVPOV"
 S DS=$S(EDT[".":EDT+.0000001,1:EDT+.240001)
 S NNODE=+$P($G(TAXARR("PDS",9000010.07,80)),U,2)
 I NNODE=0 Q
 S ICDP=""
 F  S ICDP=$O(TAXARR(80,ICDP)) Q:(ICDP="")  D
 . I '$D(^PXRMINDX(9000010.07,"IPP",ICDP)) Q
 . F IND=1:1:NNODE D
 .. S NODE=TAXARR("PDS",9000010.07,80,IND)
 .. I '$D(^PXRMINDX(9000010.07,"IPP",ICDP,NODE)) Q
 .. S DFN=0
 .. F  S DFN=$O(^PXRMINDX(9000010.07,"IPP",ICDP,NODE,DFN)) Q:DFN=""  D
 ... S DATE=DS
 ... F  S DATE=+$O(^PXRMINDX(9000010.07,"IPP",ICDP,NODE,DFN,DATE),-1) Q:(DATE=0)!(DATE<BDT)  D
 .... S DAS=$O(^PXRMINDX(9000010.07,"IPP",ICDP,NODE,DFN,DATE,""))
 .... S ^TMP($J,TLIST,DFN,DATE,DAS)=ICDP_U_"ICD9"_U_NODE
 ;Return up to NOCC of the most recent entries for each patient.
 S DFN=0
 F  S DFN=$O(^TMP($J,TLIST,DFN)) Q:DFN=""  D
 . S NFOUND=0
 . S DATE=""
 . F  S DATE=$O(^TMP($J,TLIST,DFN,DATE),-1) Q:(DATE="")!(NFOUND=NOCC)  D
 .. S DAS=""
 .. F  S DAS=$O(^TMP($J,TLIST,DFN,DATE,DAS)) Q:DAS=""  D
 ... S NFOUND=NFOUND+1
 ... S TEMP=^TMP($J,TLIST,DFN,DATE,DAS)
 ... S ICDP=$P(TEMP,U,1)
 ... S ^TMP($J,PLIST,1,DFN,NFOUND,9000010.07)=DAS_U_DATE_U_TEMP
 K ^TMP($J,TLIST)
 Q
 ;
 ;====================================================
MHVOUT(INDENT,OCCLIST,IFIEVAL,NLINES,TEXT) ;Produce the MHV output.
 N CODE,D0,DIAG,EM,ICD9P,ICD9ZN,IND,JND,NAME,NIN,NOUT,PN,RANK
 N TEMP,TEXTIN,TEXTOUT,VDATE
 S NAME="Encounter Diagnosis = "
 S IND=0
 F  S IND=$O(OCCLIST(IND)) Q:IND=""  D
 . S VDATE=IFIEVAL(IND,"DATE")
 . S ICD9P=IFIEVAL(IND,"CODEP")
 . S D0=$G(^AUPNVPOV(IFIEVAL(IND,"DAS"),0))
 . S ICD9ZN=$$ICDDX^ICDCODE(ICD9P,VDATE)
 . S CODE=$P(ICD9ZN,U,2)
 . S DIAG=$P(ICD9ZN,U,4)
 . S RANK=IFIEVAL(IND,"PRIMARY/SECONDARY")
 . S TEMP=NAME_DIAG_" ("_$$EDATE^PXRMDATE(VDATE)_")"
 . D FORMATS^PXRMTEXT(INDENT+2,PXRMRM,TEMP,.NOUT,.TEXTOUT)
 . F JND=1:1:NOUT S NLINES=NLINES+1,TEXT(NLINES)=TEXTOUT(JND)
 S NLINES=NLINES+1,TEXT(NLINES)=""
 Q
 ;
 ;====================================================
OUTPUT(INDENT,OCCLIST,IFIEVAL,NLINES,TEXT) ;Produce the clinical
 ;maintenance output. The VPOV information is:  DATE, ICD9 IEN, 
 ;ICD9 CODE, MODIFIER, PROVIDER NARRATIVE.
 N CODE,D0,DIAG,EM,ICD9P,ICD9ZN,IND,JND,NIN,NOUT,PN,RANK
 N TEMP,TEXTIN,TEXTOUT,VDATE
 S NLINES=NLINES+1
 S TEXT(NLINES)=$$INSCHR^PXRMEXLC(INDENT," ")_"Encounter Diagnosis:"
 S IND=0
 F  S IND=$O(OCCLIST(IND)) Q:IND=""  D
 . S VDATE=IFIEVAL(IND,"DATE")
 . S TEMP=$$EDATE^PXRMDATE(VDATE)
 . S ICD9P=IFIEVAL(IND,"CODEP")
 . S D0=$G(^AUPNVPOV(IFIEVAL(IND,"DAS"),0))
 . S ICD9ZN=$$ICDDX^ICDCODE(ICD9P,VDATE)
 . S CODE=$P(ICD9ZN,U,2)
 . S DIAG=$P(ICD9ZN,U,4)
 . S RANK=IFIEVAL(IND,"PRIMARY/SECONDARY")
 . S TEMP=TEMP_" "_CODE_" "_DIAG_" rank: "
 . S TEMP=TEMP_$$EXTERNAL^DILFD(9000010.07,.12,"",RANK,.EM)
 . S TEXTIN(1)=TEMP_"\\",NIN=1
 . S PN=$P(D0,U,4)
 . I PN'="" S PN=$P($G(^AUTNPOV(PN,0)),U,1)
 . I PN="" S PN="MISSING"
 . I PN'=DIAG S TEXTIN(2)="Prov. Narr. - "_PN,NIN=2
 . D FORMAT^PXRMTEXT(INDENT+2,PXRMRM,NIN,.TEXTIN,.NOUT,.TEXTOUT)
 . F JND=1:1:NOUT S NLINES=NLINES+1,TEXT(NLINES)=TEXTOUT(JND)
 . I IFIEVAL(IND,"COMMENTS")'="" D
 .. S TEMP="Comments: "_IFIEVAL(IND,"COMMENTS")
 .. D FORMATS^PXRMTEXT(INDENT+3,PXRMRM,TEMP,.NOUT,.TEXTOUT)
 .. F JND=1:1:NOUT S NLINES=NLINES+1,TEXT(NLINES)=TEXTOUT(JND)
 S NLINES=NLINES+1,TEXT(NLINES)=""
 Q
 ;
